#!/usr/bin/env python
# -*- coding: utf-8 -*-

# import required modules
import time
import subprocess
import RPi.GPIO as GPIO

# set GPIO pin with connected button
GPIOPinShut = 22

# main function
def main():
  value = 0

  while True:
    # increment value if button is pressed
    if not GPIO.input(GPIOPinShut):
      value += 0.5

    # restart or shutdown selected
    if value > 0:

      # shutdown selected if value is larger than 3 or equal
      if value >= 3:
        subprocess.call(["shutdown", "-h", "now"])
        return 0

      # restart selected if value is less than 3
      elif GPIO.input(GPIOPinShut):
        subprocess.call(["shutdown", "-r", "now"])
        return 0

    # wait 500ms
    time.sleep(0.5)

  return 0

if __name__ == '__main__':
  # use GPIO pin numbering convention
  GPIO.setmode(GPIO.BCM)

  # set up GPIO pin for input
  GPIO.setup(GPIOPinShut, GPIO.IN, pull_up_down=GPIO.PUD_UP)

  # call main function
  main()
